// Client-side validation before form submission
document.getElementById('journal-entry-form').addEventListener('submit', function(e) {
    const totalDebit = parseFloat(document.getElementById('total-debit').textContent);
    const totalCredit = parseFloat(document.getElementById('total-credit').textContent);
    
    if (totalDebit === 0 && totalCredit === 0) {
        e.preventDefault();
        alert('Please add at least one transaction');
        return false;
    }
    
    if (totalDebit !== totalCredit) {
        e.preventDefault();
        alert('Debits and credits must balance before submitting');
        return false;
    }
    
    return true;
});