from django.urls import path

from .views import account_list, create_account, purchase_order_list, purchase_order_delete, create_purchase_order, purchase_return_view
from .views import purchase_order_edit,  purchase_order_detail, income_statement, accounting_dashboard
from .views import  load_jobs , load_jobs_for_supplier
from .views import create_journal_entry, journal_entry_list, general_ledger, trial_balance, journal_entry_detail, edit_journal_entry
from .views import job_profit_loss, get_companies_by_supplier, get_companies_by_customer


urlpatterns = [
   
    # Purchase Order URLs
    path('purchase-orders/', purchase_order_list, name='purchase_order_list'),
    path('purchase-orders/new/', create_purchase_order, name='create_purchase_order'),
    path('ajax/load-jobs/', load_jobs, name='ajax_load_jobs'),
    path('purchase-orders/edit/<int:pk>/', purchase_order_edit, name='purchase_order_edit'),
    path('purchase-orders/delete/<int:pk>/', purchase_order_delete, name='purchase_order_delete'),
    path('purchase-orders/<int:pk>/', purchase_order_detail, name='purchase_order_detail'),
    path('purchase-orders/<int:pk>/return/', purchase_return_view, name='purchase_return_view'),
    path('get_companies_by_supplier/<int:supplier_id>/', get_companies_by_supplier, name='get_companies_by_supplier'),
    
    # Journal Entry URLs
    path('journal-entry/new/', create_journal_entry, name='create_journal_entry'),
    path('reports/general-ledger/', general_ledger, name='general_ledger'),
    
    path('journal-entries/', journal_entry_list, name='journal_entry_list'),
    path('journal-entries/<int:pk>/', journal_entry_detail, name='journal_entry_detail'),
    path('journal-entries/<int:pk>/edit/', edit_journal_entry, name='journal_entry_edit'),
    # AJAX URL for loading jobs based on supplier selection in the purchase order form
    path('ajax/load-jobs/', load_jobs_for_supplier, name='ajax_load_jobs'),

    # financial reports
    path('reports/trial-balance/', trial_balance, name='trial_balance'),
    path('income-statement/', income_statement, name='income_statement'),
    path('dashboard/', accounting_dashboard, name='accounting_dashboard'),
    path('reports/job/<int:job_id>/profit-loss/', job_profit_loss, name='job_profit_loss'),

    # API URL for product stock

    # Accounts 
    path('accounts/create/', create_account, name='create_account'),
    path('accounts/', account_list, name='account_list'),

]
