from django import forms
from .models import Supplier, Customer, Transporter, Company

class SupplierForm(forms.ModelForm):
    class Meta:
        model = Supplier
        fields = ['name',  'tax_id', 'cnic', 'country', 'bank_account_details', 
                  'license_document', 'supplier_type', 'email', 'phone', 'address']
        widgets = {
            'address': forms.Textarea(attrs={'rows': 2}),
            'bank_account_details': forms.Textarea(attrs={'rows': 2}),
        }

class CustomerForm(forms.ModelForm):
    class Meta:
        model = Customer
        fields = '__all__'
        
       

class TransporterForm(forms.ModelForm):
    class Meta:
        model = Transporter
        fields = ['name',  'company_name', 'bank_account_details', 'email', 'phone', 'address']


        

class CompanyForm(forms.ModelForm):
    class Meta:
        model = Company
        fields = '__all__'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['supplier'].widget.attrs.update({'class': 'form-control'})
        self.fields['customer'].widget.attrs.update({'class': 'form-control'})