from django.db import models
from django.utils.translation import gettext_lazy as _
from datetime import date
from django.contrib.auth.models import User



# Create your models here.
# Supplier Model
class Supplier(models.Model):
    TYPE_CHOICES = [
        ('Local', 'Local'),
        ('Import', 'Import'),
        ('Export', 'Export'),
    ]

    name = models.CharField(max_length=255)
    tax_id = models.CharField(max_length=50, null=True, blank=True)
    cnic = models.CharField(max_length=15, null=True, blank=True)
    country = models.CharField(max_length=100, null=True, blank=True)
    bank_account_details = models.TextField(null=True, blank=True)
    license_document = models.FileField(upload_to='uploads/licenses/', null=True, blank=True)
    supplier_type = models.CharField(max_length=10, choices=TYPE_CHOICES, default='Local')
    email = models.EmailField(unique=True)
    phone = models.CharField(max_length=20)
    address = models.TextField()
    created_by = models.ForeignKey(User, on_delete=models.CASCADE, null=True, blank=True)
    created_at = models.DateField(auto_now_add=True, null=True, blank=True)

    def __str__(self):
        return self.name

# Customer Model
class Customer(models.Model):
    TYPE_CHOICES = [
        ('Local', 'Local'),
        ('Import', 'Import'),
        ('Export', 'Export'),
    ]
    name = models.CharField(max_length=255)
    tax_id = models.CharField(max_length=50, null=True, blank=True)
    cnic = models.CharField(max_length=15, null=True, blank=True)
    country = models.CharField(max_length=100, null=True, blank=True)
    bank_account_details = models.TextField(null=True, blank=True)
    license_document = models.FileField(upload_to='uploads/licenses/', null=True, blank=True)
    customer_type = models.CharField(max_length=10, choices=TYPE_CHOICES, default='Local')
    email = models.EmailField(unique=True)
    phone = models.CharField(max_length=20)
    address = models.TextField()
    created_by = models.ForeignKey(User, on_delete=models.CASCADE, null=True, blank=True)
    created_at = models.DateField(auto_now_add=True, null=True, blank=True)

    def __str__(self):
        return self.name
    

# Tranporter Model
class Transporter(models.Model):

    name = models.CharField(max_length=255)
    company_name = models.CharField(max_length=255, null=True, blank=True)
    bank_account_details = models.TextField(null=True, blank=True)
    email = models.EmailField(unique=True)
    phone = models.CharField(max_length=20)
    address = models.TextField()
    created_by = models.ForeignKey(User, on_delete=models.CASCADE, null=True, blank=True)
    created_at = models.DateField(auto_now_add=True)

    def __str__(self):
        return self.name


# Company Model
class Company(models.Model):
    company_name = models.CharField(max_length=255)
    country = models.CharField(max_length=100, null=True, blank=True)
    email = models.EmailField(unique=True)
    phone = models.CharField(max_length=20)
    address = models.TextField()
    customer = models.ForeignKey(Customer, on_delete=models.CASCADE, null=True, blank=True)
    supplier = models.ForeignKey(Supplier, on_delete=models.CASCADE, null=True, blank=True)
    created_by = models.ForeignKey(User, on_delete=models.CASCADE, null=True, blank=True)
    created_at = models.DateField(auto_now_add=True)
    
    def __str__(self):
        return self.company_name
    
   


