from django.urls import path
from .views import add_supplier, add_customer, edit_supplier, delete_supplier, supplier_ledger
from .views import add_transporter, transporter_list, edit_transporter, delete_transporter
from .views import edit_customer, delete_customer, supplier_list, customer_list, customer_ledger
from .views import company_list, add_company, edit_company, delete_company

urlpatterns = [
    path('add-supplier/', add_supplier, name='add_supplier'), 
    path("suppliers/", supplier_list, name="supplier_list"),
    path("supplier/edit/<int:pk>/", edit_supplier, name="edit_supplier"),
    path("supplier/delete/<int:pk>/", delete_supplier, name="delete_supplier"),
    path('supplier/<int:supplier_id>/ledger/', supplier_ledger, name='supplier_ledger'),
    
    path('add-customer/', add_customer, name='add_customer'),
    path("customers/", customer_list, name="customer_list"),
    path("customer/edit/<int:pk>/", edit_customer, name="edit_customer"),
    path("customer/delete/<int:pk>/", delete_customer, name="delete_customer"),
    path('customer/<int:customer_id>/ledger/', customer_ledger, name='customer_ledger'),
    
    path('add-transporter/', add_transporter, name='add_transporter'),
    path("transporter/", transporter_list, name="transporter_list"),
    path("transporter/edit/<int:pk>/", edit_transporter, name="edit_transporter"),
    path("transporter/delete/<int:pk>/", delete_transporter, name="delete_transporter"),

    path('add-company/', add_company, name='add_company'),
    path("company/", company_list, name="company_list"),
    path("company/edit/<int:pk>/", edit_company, name="edit_company"),
    path("company/delete/<int:pk>/", delete_company, name="delete_company"),

]