from django.urls import path
from .views import add_product, create_material_consumption, get_product_stock, material_consumption_detail, material_consumption_list, product_list, edit_product, delete_product
from .views import stock_dashboard, stock_movement_list, add_stock_movement


urlpatterns = [
    path('add-product/', add_product, name='add_product'),
    path("products/", product_list, name="product_list"),
    path("edit/<int:pk>/", edit_product, name="edit_product"),
    path("delete/<int:pk>/", delete_product, name="delete_product"),


    path('stock/', stock_dashboard, name='stock_dashboard'),
    path('movements/', stock_movement_list, name='stock_movement_list'),
    path('movements/add/', add_stock_movement, name='add_stock_movement'),
    path('material-consumption/create/', create_material_consumption, name='create_material_consumption'),
    path('material_consumption_list', material_consumption_list, name='material_consumption_list'),
    path('get-product-stock/', get_product_stock, name='get_product_stock'),
    path('material-consumption/<int:pk>/', material_consumption_detail, name='material_consumption_detail'),


]
