# Generated by Django 5.1.7 on 2025-05-24 04:24

import datetime
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_code', models.CharField(max_length=100)),
                ('project_title', models.CharField(max_length=255)),
                ('project_description', models.TextField(blank=True, null=True)),
                ('awarding_department', models.CharField(max_length=255, null=True)),
                ('site_location', models.CharField(blank=True, max_length=200, null=True)),
                ('commencement_date', models.DateField(default=datetime.date.today)),
                ('completion_date', models.DateField(blank=True, null=True)),
                ('loi_date', models.DateField(blank=True, null=True)),
                ('work_award_amount', models.DecimalField(decimal_places=4, max_digits=12)),
                ('percent_estimate', models.DecimalField(decimal_places=4, max_digits=10)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProjectDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document_type', models.CharField(choices=[('Bill', 'Bills'), ('Invoice', 'Invoice'), ('Gate Pass', 'Gate Pass'), ('PO', 'Purchase Order (PO)'), ('Weight Slip', 'Weight Slip')], max_length=50)),
                ('document', models.FileField(upload_to='project_documents/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('notes', models.TextField(blank=True, null=True)),
                ('Project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to='projects.project')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
