from decimal import Decimal
import re
from django.db import models
from django.utils.translation import gettext_lazy as _
from datetime import date
from django.contrib.auth.models import User


# Create your models here.
# Project Model (For project-based tracking)
class Project(models.Model):
    project_code = models.CharField(max_length=100)
    project_title = models.CharField(max_length=255)
    project_description = models.TextField(blank=True, null=True)
    awarding_department = models.CharField(max_length=255, null=True)
    site_location = models.CharField(max_length=200, blank=True, null=True)
    commencement_date = models.DateField(default=date.today)
    completion_date = models.DateField(blank=True, null=True)
    loi_date = models.DateField(blank=True, null=True)
    work_award_amount = models.DecimalField(max_digits=12, decimal_places=4)
    percent_estimate = models.DecimalField(max_digits=4, decimal_places=2)
    created_by = models.ForeignKey(User, on_delete=models.SET_NULL, null=True, blank=True)

    def __str__(self):
        return f"{self.project_title} "

class ProjectDocument(models.Model):
    DOCUMENT_TYPES = [
        ('Bill', 'Bills'),
        ('Invoice', 'Invoice'),
        ('Gate Pass', 'Gate Pass'),
        ('PO', 'Purchase Order (PO)'),
        ('Weight Slip', 'Weight Slip'),
    ]

    project = models.ForeignKey(Project, on_delete=models.CASCADE, related_name='documents')
    document_type = models.CharField(max_length=50, choices=DOCUMENT_TYPES)
    document = models.FileField(upload_to='project_documents/')
    uploaded_at = models.DateTimeField(auto_now_add=True)
    notes = models.TextField(blank=True, null=True)  # Optional: if you want extra comments
    created_by = models.ForeignKey(User, on_delete=models.SET_NULL, null=True, blank=True)

    def __str__(self):
        return f"{self.project.project_title} - {self.get_document_type_display()}"
    



class LaborCost(models.Model):
    project = models.ForeignKey(Project, on_delete=models.CASCADE)
    description = models.CharField(max_length=255)
    amount = models.DecimalField(max_digits=12, decimal_places=2)
    date = models.DateField()

class IndirectCost(models.Model):
    project = models.ForeignKey(Project, on_delete=models.CASCADE, null=True, blank=True)
    type = models.CharField(max_length=255)
    amount = models.DecimalField(max_digits=12, decimal_places=2)
    date = models.DateField()
    is_allocated = models.BooleanField(default=False)